/*------------------------------------------------
- Gtk Wget GTK front End for Wget                -
- Copyright 2001 Marina Brown GNU Public License -
--------------------------------------------------*/
#include <stdio.h>
#include <gtk/gtk.h>

#define EMPTY(str) (!strncmp(str,""))

/*----------------------------------------------------------
- Function Declarations ...introducing the cast ;)         -
-----------------------------------------------------------*/
int main(int argc, char *argv[]);
static void menuitem_response(gchar *);
int show_file_text(FILE *infil,
                   int save, 
                   int print, 
                   int x, 
                   int y, 
                   char *title,
                   int blocksize,
                   gboolean scroll);
void about(void);
int fetch(void);
void select_user_agent(void);
void get_input(void);
void add_entry_to_command_line(GtkWidget *to_add, char *flag);

/*-----------------------------------------------------------
-                     Global Variables                      -
------------------------------------------------------------*/
char *menutext[]= {"Wget version",
                   "About GTKWget",
                   "Wget command line",
                   "License",
                   "Quit"};

char *page_name[] = {"Defaults",
                     "Recursion",
                     "Input
Output",
                     "advanced",
                     "Settings"};

/*--------------------------------------------------------
-              Command line set to 256 chars             -
---------------------------------------------------------*/
char command_line[1024];
char *command_line_place;

/*------------------------------
-  variables for  Notebook     -
-------------------------------*/
GtkWidget *table; 
GtkWidget *label;
GtkWidget *url_text;
GtkWidget *download_dir_text;
GtkWidget *recursive_check;
GtkWidget *no_parent_check;
GtkWidget *no_clobber_check; 
GtkWidget *continue_check; 
GtkWidget *agent_text;
//GtkWidget *background_check;
GtkWidget *timestamping_check; 
GtkWidget *tries_text; 
GtkWidget *timeout_text; 
GtkWidget *wait_text;
GtkWidget *frame;
GtkWidget *button;
GtkWidget *sub_table;
GtkWidget *no_host_dirs_check;
GtkWidget *recursion_depth_text;

/*-------------------------------------------------------------------------
-                         page_build_2 variables                          -
--------------------------------------------------------------------------*/
GtkWidget *accept_text;
GtkWidget *reject_text;
GtkWidget *domains_text;
GtkWidget *exclude_domains_text;
GtkWidget *include_directories_text;
GtkWidget *excluded_directories_text;
GtkWidget *quota_text;
GtkWidget *span_hosts_check;
GtkWidget *relative_check;
GtkWidget *follow_ftp_check;
GtkWidget *ftp_symlinks_check;
GtkWidget *file_globbing_check;
GtkWidget *passive_ftp_check;
//GtkWidget *follow_ftp_links_check;


/*--------------------------------------------------------------------------
-                         page_build_3 variables                           -
---------------------------------------------------------------------------*/
GtkWidget *convert_to_non_rel_check;
GtkWidget *mirroring_check;
GtkWidget *no_directories_check;
GtkWidget *force_directories_check;
GtkWidget *disallow_cache_check;
GtkWidget *disallow_cache_check;
GtkWidget *vbox;
GtkWidget *hbox;

/*-------------------------------------------------------------------------
-                            page_build_4 variables                       -
--------------------------------------------------------------------------*/
GtkWidget *input_file_text;
GtkWidget *force_html_check;
GtkWidget *remove_input_file_lines_check;

/*----------------------------------------------------------------------------
-                           page_build_5 variables                           -
-----------------------------------------------------------------------------*/
GtkWidget *use_proxy_check;
GtkWidget *proxy_user_text;
GtkWidget *proxy_passwd_text;
GtkWidget *http_user_text;
GtkWidget *http_password_text;

/*---------------------------------------------------------------------------
-                         page_build_6 variables                            -
----------------------------------------------------------------------------*/
GtkWidget *output_file_text;
GtkWidget *append_file_text;
GtkWidget *quiet_check ;
GtkWidget *output_document_text;
GtkWidget *dot_style_text;
GtkWidget *server_response_check;
GtkWidget *spider_check;
GtkWidget *debug_check;
GtkWidget *save_headers_check;
GtkWidget *verbose_check;
GtkWidget *non_verbose_check;

/*---------------------------------------------------------------------------
-                           page_build_7 variables                          -
----------------------------------------------------------------------------*/
GtkWidget *no_host_lookup_check;
GtkWidget *dont_remove_listing_check;
GtkWidget *delete_after_check;
GtkWidget *wgetrc_command_text;

/*---------------------------------
-    declaration for page_build   -
----------------------------------*/
void page_build_1();
void page_build_2();
void page_build_3();
void page_build_4();
void page_build_5();

/*---------------------------------------------------------------------
-                 Array of ptrs to page_build functions               -
----------------------------------------------------------------------*/
void (*page_build[])(void) = {page_build_1,
                              page_build_2,
                              page_build_3,
                              page_build_4,
                              page_build_5};

/*--------------------------------------------------------
-                          main                          -
---------------------------------------------------------*/
int main(int argc, char *argv[])
{
    GtkWidget *window, *menu, *menu_bar, *root_menu, *menu_items;
    GtkWidget  *label, *table, *notebook;

// footest
    GtkWidget  *foo_text;

    GtkWidget *checkbutton;
    char bufferf[32];
    char bufferl[32];

    char buf[128];
    int i;

    gtk_init (&argc, &argv);

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize (GTK_WIDGET (window), 465, 460);
    gtk_window_set_title (GTK_WINDOW (window), "GTKwget");
    gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                        (GtkSignalFunc) gtk_main_quit, NULL);

    /*-----------------------
    -   Begin menu stuff    -
    ------------------------*/
    /*-----------------------------------------------------------------
    -  Init the menu-widget, and remember -- never gtk_show_widget()  -
    ------------------------------------------------------------------*/
    menu = gtk_menu_new ();

    /* Add the menu items  */
    for (i = 0; i < 5; i++)/* change this to something more dynamic */
    {                      /* Like sizof menutext/sizof *gtkwidget  */
        sprintf (buf, menutext[i]);
        menu_items = gtk_menu_item_new_with_label (buf);
        gtk_menu_append (GTK_MENU (menu), menu_items);
        gtk_signal_connect_object (GTK_OBJECT (menu_items), "activate",
                                   GTK_SIGNAL_FUNC (menuitem_response), 
                                   (gpointer) g_strdup (buf));
        gtk_widget_show (menu_items);
    }
    root_menu = gtk_menu_item_new_with_label ("GTKWget");
    gtk_widget_show (root_menu);

    /*------------------------------------------------ 
    -  Now we specify that we want our newly created - 
    -  "menu" to be the menu * for the "root menu"   -
    -------------------------------------------------*/
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);

    /*-----------------------------------------
    -  A vbox to put a menu and a button in:  -
    ------------------------------------------*/
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    gtk_widget_show (vbox);

    /*---------------------------------------------------------------------
    -  Create a menu-bar to hold the menus and add it to our main window  -
    ----------------------------------------------------------------------*/
    menu_bar = gtk_menu_bar_new ();
    gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, FALSE, 2);
// footest
    foo_text = gtk_entry_new_with_max_length(256);
    gtk_widget_set_usize(GTK_WIDGET(foo_text),200,15);
    gtk_widget_show (foo_text);
    gtk_container_add(GTK_CONTAINER(vbox),foo_text);
    gtk_widget_show(foo_text);
// footest

    gtk_widget_show (menu_bar);
    gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu);
    /*-----------------------
    -     End menu stuff    -
    ------------------------*/

    table = gtk_table_new(3,6,FALSE);
    gtk_container_add (GTK_CONTAINER(vbox),table);

    notebook = gtk_notebook_new ();
//    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),GTK_POS_LEFT);
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),GTK_POS_TOP);
    gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,6,0,1);
    gtk_widget_show(notebook);

    for (i=0; i < 5; i++) {
        sprintf(bufferf, page_name[i]);
        sprintf(bufferl, page_name[i]);

        frame = gtk_frame_new (bufferf);
        gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
        gtk_widget_set_usize (frame, 200, 150);
        gtk_widget_show (frame);
        page_build[i]();

        label = gtk_label_new (bufferl);
        gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
    }

    /*--------------------------------------
    -  Set what page to start at (page 1)  -
    ---------------------------------------*/
    gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);

    gtk_widget_show(table);

    /*--------------------
    - begin button stuff -
    ---------------------*/
    button = gtk_button_new_with_label (" Close ");
    gtk_signal_connect_object (GTK_OBJECT (button),
                               "clicked", (GtkSignalFunc) gtk_main_quit,
                               NULL);
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     0, 1, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);

    button = gtk_button_new_with_label (" Cancel ");
    gtk_signal_connect_object (GTK_OBJECT (button),
                               "clicked", (GtkSignalFunc) printf,
                               (gpointer)("Not yet implemented !\n"));
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     1, 2, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);
 
    button = gtk_button_new_with_label ("Fetch !");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        (GtkSignalFunc) fetch,
                        NULL);
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     2, 3, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);

    button = gtk_button_new_with_label ("Command Line");
    gtk_signal_connect_object (GTK_OBJECT (button),
                               "clicked", (GtkSignalFunc) printf,
                               (gpointer)("Not yet implemented !\n"));
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     3, 4, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);

    /*--- end button stuff ---*/

    /*---------------------------------------------
    -  always display the window as the last step -
    -  so it all splashes on the screen at once.  -
    ----------------------------------------------*/
    gtk_widget_show (window);

    gtk_main ();

    return(0);
}

/*-----------------------------------------------
-  Print a string when a menu item is selected  -
-  Create popup windows with the info in a read -
-  only scrollable window 'cept for quit and    -
-  about !                                      -
------------------------------------------------*/
static void menuitem_response( gchar *string )
{
    FILE *fs;

    if(strcmp(string,"About GTKWget")== 0)
        about();
    else if(strcmp(string,"Wget version")== 0)
    {
        fs = popen("wget --version", "r");
        if(fs != NULL)
        {
            show_file_text(fs,0,0,500,250,"wget version",1024,FALSE);
            pclose(fs);
        }
        else
            printf("Error opening Pipe !\n");
    }
    else if(strcmp(string,"Wget command line")== 0)
    {
        fs = popen("wget -h", "r");
        if(fs != NULL)
        {
            show_file_text(fs,0,0,550,500,"wget command line",1024,FALSE);
            pclose(fs);
        }
        else
            printf("Error opening pipe !\n");
    }
    else if(strcmp(string,"License")== 0)
    {
        fs = fopen("COPYING", "r");
        if(fs != NULL)
        {
            show_file_text(fs,0,0,620,500,"Gnu Public License",1024,FALSE);
            fclose(fs);
        }
        else
            printf("Get a copy of the GPL ! This software is GPLed\n");
    }
    else if(strcmp(string,"Quit")== 0)
        gtk_main_quit();
    else
        printf("DID not Werk !");
}


/*--------------------------------------------------------------------
-                            show_text                               -
- Save button will show if save = 1, print button, to be implemented -
- if print = 1 a print dialog shows up                               -
---------------------------------------------------------------------*/
int show_file_text(FILE *infil,
                   int save, 
                   int print, 
                   int x, 
                   int y, 
                   char *title,
                   int blocksize,
                   gboolean scroll)
{
  GtkWidget *filew;
  GtkWidget *window, *box1, *box2, *hbox, *button, *check;
  GtkWidget *table, *vscrollbar, *text, *fs;
  GdkColormap *cmap;
  GdkFont *fixed_font;
  char buffer[1024];
  char *filename="                                                           ";
  int nchars;
  guint read_timeout;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_usize (window, x, y);
  gtk_window_set_policy (GTK_WINDOW(window), TRUE, TRUE, FALSE);  
  gtk_window_set_title (GTK_WINDOW (window), title);
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);
  gtk_widget_show (box1);
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);
  
  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
  
  /*-----------------------------
  -  Create the GtkText widget  -
  ------------------------------*/
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (text), FALSE);
  gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
                    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (text);

  /*--------------------------------------------------
  -  Add a vertical scrollbar to the GtkText widget  -
  ---------------------------------------------------*/
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
                    GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);

  /*---------------------
  -  Load a fixed font  -
  ----------------------*/
  fixed_font=gdk_font_load("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");

  /*------------------------------------------
  -  Realizing a widget creates a window for - 
  -  it, ready for us to insert some text    -
  -------------------------------------------*/
  gtk_widget_realize (text);

  
  hbox = gtk_hbutton_box_new ();
  gtk_box_pack_start (GTK_BOX (box2), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  box2 = gtk_hbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);
  

  /*-------------------------------------------------------------------
  -                Create Close Button - connect with signals         -
  --------------------------------------------------------------------*/
  button = gtk_button_new_with_label ("close");
  gtk_signal_connect_object (GTK_OBJECT (button),
                             "clicked", (GtkSignalFunc) gtk_widget_destroy,
                             GTK_OBJECT (window));

  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
                      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_show (button);

  if(scroll)
      gtk_widget_show (window);

  /*--- FILE LOAD TO WINDOW ---*/
  /*-------------------------------
  -  Freeze the text widget,      -
  -  ready for multiple updates   -
  --------------------------------*/
//  gtk_text_freeze (GTK_TEXT (text));
/*--- TEST ---*/
  gtk_text_thaw(GTK_TEXT(text));
  
  if(infil!=NULL)
  {
    while (1)
    {
      while (gtk_events_pending())gtk_main_iteration();
      nchars = fread(buffer, 1, blocksize, infil);
      gtk_text_insert(GTK_TEXT(text),NULL,&text->style->black,
                      NULL,buffer,nchars);
      if (nchars < blocksize)
        break;
    }
  }
  else
    g_print("%s pointer = %p \n", "The file could not be opened !", infil);

  /*----------------------------------------------------------------
  -  Thaw the text widget, allowing the updates to become visible  -
  -----------------------------------------------------------------*/  
//  gtk_text_thaw(GTK_TEXT(text));
  /*--- END FILE LOAD TO WINDOW ---*/
  if(!scroll)
      gtk_widget_show (window);
  return(0);       
}

/*-----------------------------------------------------------------------
-                             about - show credits                      -
------------------------------------------------------------------------*/
void about(void)
{
     static GtkWidget *window = NULL;
     GtkWidget *hbox, *vbox, *frame, *button, *label;

     window = gtk_window_new (GTK_WINDOW_DIALOG);

     gtk_window_set_title (GTK_WINDOW (window), "Label");
     hbox = gtk_hbox_new (FALSE, 5);
     vbox = gtk_vbox_new (FALSE, 5);

     gtk_container_add (GTK_CONTAINER (window), hbox);
     gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
     gtk_container_set_border_width (GTK_CONTAINER (window), 5);
     
     frame = gtk_frame_new ("GTKwget");
     label = gtk_label_new ( 
"GTKWget Version 0.01 by Marina Brown. A graphical interface
for wget, the best non-interactive Web fetch program on the
net ! Copyright 2001, Gnu Public License by Marina Brown and
Laura deGrey. Most programming by Marina. Testing, debugging,
pertinant suggestions, layout and handholding by Laura deGrey.");

     gtk_container_add (GTK_CONTAINER (frame), label);
     gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

     button = gtk_button_new_with_label ("close");
     gtk_signal_connect_object (GTK_OBJECT (button),
                                "clicked", (GtkSignalFunc) gtk_widget_destroy,
                                GTK_OBJECT (window));
     gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
 
     gtk_widget_show_all (window);
}


/*--------------BEGIN NOTEBOOK BUILD FUNCTIONS----------------*/
/*----------------------------------------------------------------------
-                             Begin page_build_1                       -
-----------------------------------------------------------------------*/
void page_build_1()
{
    vbox=gtk_vbox_new(FALSE,0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    /*----URL and DIR and AGENT---*/
    /*--------------------------------------------------------------------------
    - text entry for url to get from -- optionally a dropdown menu or clist    -
    - widget containing bookmarks on right - previously entered sites-possibly -
    - an option to use the netscape bookmarks. a button could allow browsing.   
    --------------------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);
    table = gtk_table_new (3, 3, TRUE);
    gtk_box_pack_start(GTK_BOX(hbox),table,TRUE,TRUE,0);
    label = gtk_label_new ("Url:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 0, 1);
    gtk_widget_show (label);
    gtk_widget_show (table);
    gtk_widget_show (hbox);

    url_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults(GTK_TABLE(table),url_text, 1, 2, 0, 1);
    gtk_widget_show (url_text);
    button=gtk_button_new_with_label("bookmarks");
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     2, 3, 0, 1,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show (button);


    /*------------------------------------------------------------------------
    - text entry to select where to d/l to. File widget pop-up to easier     -
    - select area to d/l to. Must have error checking to see if the selected -
    - region is directory. Filesel and text entry should default to pwd.     -
    -------------------------------------------------------------------------*/
    label = gtk_label_new ("Dir:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 1, 2);
    gtk_widget_show (label);

    download_dir_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults(GTK_TABLE(table),download_dir_text, 1, 2, 1, 2);
    gtk_widget_show (download_dir_text);

    button=gtk_button_new_with_label("  browse   ");
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     2, 3, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show (button);
    gtk_widget_show (table);

    /*------------------------------------------------------------------------
    - -U,  --user-agent=AGENT    identify as AGENT instead of Wget/VERSION.  -
    - (drop down list with option to enter a value -- ddl should be able to  -
    -  get new entries -- add to config file)                                -
    -  Button calls a function to call a widget to allow selection of User   -
    -  Agent.                                                                -
    -------------------------------------------------------------------------*/
    label = gtk_label_new ("User Agent:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 2, 3);
    gtk_widget_show (label);

    agent_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults(GTK_TABLE(table),agent_text, 1, 2, 2, 3);
    gtk_widget_show (agent_text);

    button = gtk_button_new_with_label ("   Select   ");
    gtk_table_attach(GTK_TABLE(table),  button,
                     2, 3, 2, 3,
                     GTK_SHRINK,
                     GTK_SHRINK,
                     0,0);
    gtk_signal_connect_object (GTK_OBJECT (button),
                               "clicked", (GtkSignalFunc) select_user_agent,
                               NULL);
    gtk_widget_show (button);

    /*----End URL and DIR and AGENT----*/

    /*-------------------------------*/
    /*----Begin Table 7 rows,2 cols----*/
    /*-------------------------------*/
    /*-------------------------
    - Check box for recursive -
    --------------------------*/
    hbox=gtk_hbox_new(FALSE,0);
    table=gtk_table_new(7,2,FALSE);
    gtk_box_pack_start(GTK_BOX(hbox),table,FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER(vbox), hbox);
    recursive_check = gtk_check_button_new_with_label ("Recursive");
    gtk_table_attach(GTK_TABLE(table), 
                     recursive_check , 
                     0, 1, 0, 1,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (recursive_check);
    gtk_widget_show (hbox);
    gtk_widget_show (table);

    /*----------------------------------------------------------------
    - checkbox for -np (No parent for recursive) checked as default. -
    -----------------------------------------------------------------*/
    no_parent_check = gtk_check_button_new_with_label("No Parent Dirs");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(no_parent_check),TRUE);
    gtk_table_attach(GTK_TABLE(table), 
                     no_parent_check, 
                     1, 2, 0, 1,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (no_parent_check);

    /*--------------------------------------------------------------------
    - checkbox (! selected as default) for -nH option (as advances this  -
    - should go in settings)                                             -
    ---------------------------------------------------------------------*/
    no_host_dirs_check = gtk_check_button_new_with_label("No Host Dirs");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(no_host_dirs_check),TRUE);
    gtk_table_attach(GTK_TABLE(table), 
                     no_host_dirs_check, 
                     0, 1, 1, 2,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (no_host_dirs_check);

    /*-----------------------------------------------------------------------
    - -N,  --timestamping don't retrieve files older than local. (checkbox) -
    ------------------------------------------------------------------------*/
    timestamping_check = gtk_check_button_new_with_label("No Older Files");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(timestamping_check),TRUE);
    gtk_table_attach(GTK_TABLE(table), 
                     timestamping_check, 
                     1, 2, 1, 2,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (timestamping_check);


    /*-------------------------------------------------------
    - -nc, --no-clobber (checkboxes - mutually exclusive !) -
    --------------------------------------------------------*/
    gtk_widget_show (label);
    no_clobber_check = gtk_check_button_new_with_label("No Clobber");
    gtk_table_attach(GTK_TABLE(table), 
                     no_clobber_check, 
                     0, 1, 2, 3,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (no_clobber_check);

    /*---------------------------------------
    - -c,  --continue EXCLUDES previous box -
    ----------------------------------------*/
    continue_check = gtk_check_button_new_with_label("Continue D/L");
    gtk_table_attach(GTK_TABLE(table), 
                     continue_check, 
                     1, 2, 2, 3,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (continue_check);

    /*-------same line----*/
    /*-----------------------------------------------------------------------
    - -k, --convert-links convert non-relative links to relative. (checkbox)-
    ------------------------------------------------------------------------*/
    convert_to_non_rel_check=gtk_check_button_new_with_label("Convert to relative");
    gtk_table_attach(GTK_TABLE(table),
                     convert_to_non_rel_check,
                     0, 1, 3, 4,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(convert_to_non_rel_check);

    /*------------------------------------------------------------------------
    -   -m,  --mirror  turn on options suitable for mirroring. (checkbox)    -
    -------------------------------------------------------------------------*/
    mirroring_check=gtk_check_button_new_with_label("Mirror");
    gtk_table_attach(GTK_TABLE(table),
                     mirroring_check,
                     1, 2, 3, 4,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(mirroring_check);
    gtk_widget_show(hbox);
    gtk_widget_show(table);
    /*--------end same line--------*/

    no_directories_check=gtk_check_button_new_with_label("Don't Create Directories");
    gtk_table_attach(GTK_TABLE(table),
                     no_directories_check,
                     0, 1, 4, 5,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(no_directories_check);
    force_directories_check=gtk_check_button_new_with_label("Force Directories");
    gtk_table_attach(GTK_TABLE(table),
                     force_directories_check,
                     1, 2, 4, 5,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(force_directories_check);
    gtk_widget_show(hbox);

    /*------------------------------------------------------------------------
    - -C,  --cache=on/off  (dis)allow server-cached data (normally allowed). -
    -------------------------------------------------------------------------*/
    disallow_cache_check=gtk_check_button_new_with_label("Disallow Cached Data");
    gtk_table_attach(GTK_TABLE(table),
                     disallow_cache_check,
                     0, 1, 5, 6,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(disallow_cache_check);

    /*------------------------------------------------------------------------
    -        --ignore-length ignore `Content-Length' header field.           -
    -------------------------------------------------------------------------*/
    disallow_cache_check=gtk_check_button_new_with_label("Ignore Content-Length");
    gtk_table_attach(GTK_TABLE(table),
                     disallow_cache_check,
                     1, 2, 5, 6,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(disallow_cache_check);
    gtk_widget_show(table);
    /*-------end same line-------*/

    /*-----------------------------------------------------------------------
    -  work in Background (checkbox) ..not checked (though configurable) -b -
    ------------------------------------------------------------------------*/
/*
    background_check = gtk_check_button_new_with_label("Work in Background");
    gtk_table_attach(GTK_TABLE(table),
                     background_check,
                     0, 1, 6, 7,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(background_check);
*/
    /*-------------------------------*/
    /*----End Table 7 rows,2 cols----*/
    /*-------------------------------*/

    /*----Begin table 2 rows, 4 cols----*/
    /*---merge table---*/
    /*-------------------------------------------------------------
    - -t,  --tries=NUMBER (0 unlimits) (text entry and checkbox)  -
    --------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    gtk_container_add (GTK_CONTAINER(vbox), hbox);
    table = gtk_table_new (2, 4, TRUE);
    gtk_box_pack_start(GTK_BOX(hbox),table,FALSE,FALSE,0);
    label = gtk_label_new ("Tries:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach(GTK_TABLE(table), label, 
                     0, 1, 0, 1,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show (label);

    tries_text = gtk_entry_new_with_max_length(2);
    gtk_table_attach(GTK_TABLE(table), 
                     tries_text, 
                     1, 2, 0, 1,
                     GTK_SHRINK,GTK_SHRINK,
                     0,3);
    gtk_widget_set_usize(GTK_WIDGET(tries_text),20,20);
    gtk_widget_show (tries_text);

   /*----small entry tables---*/
    /*------------------------------------------------------
    - -T,  --timeout=SECONDS     (text entry and checkbox) -
    -------------------------------------------------------*/
    label = gtk_label_new ("Timeout:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach (GTK_TABLE(table), 
                      label, 
                      2, 3, 0, 1,
                      GTK_SHRINK,GTK_SHRINK,
                      0,3);

    gtk_widget_show (label);

    timeout_text = gtk_entry_new_with_max_length(2);
    gtk_table_attach(GTK_TABLE(table), 
                     timeout_text, 
                     3, 4, 0, 1,
                     GTK_SHRINK,GTK_SHRINK,
                     0,3);
    gtk_widget_set_usize(GTK_WIDGET(timeout_text),20,20);
    gtk_widget_show (timeout_text);

    /*-----------------------------------------------------
    - -w,  --wait=SECONDS       (text entry and checkbox) -
    ------------------------------------------------------*/
    label = gtk_label_new ("Wait:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach (GTK_TABLE(table), 
                      label, 
                      0, 1, 1, 2,
                      GTK_SHRINK,GTK_SHRINK,
                      0,3);
    gtk_widget_show (label);

    wait_text = gtk_entry_new_with_max_length(2);
    gtk_table_attach(GTK_TABLE(table), 
                     wait_text, 
                     1, 2, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     0,3);
    gtk_widget_set_usize(GTK_WIDGET(wait_text),20,20);
    gtk_widget_show (wait_text);
    gtk_widget_show (hbox);

    /*-----------------------
    - -l level of recursion -
    ------------------------*/
    label = gtk_label_new ("Depth:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach (GTK_TABLE(table),
                      label,
                      2, 3, 1, 2,
                      GTK_SHRINK,GTK_SHRINK,
                      0,3);
    gtk_widget_show (label);

    recursion_depth_text= gtk_entry_new_with_max_length(2);
    gtk_table_attach(GTK_TABLE(table),
                     recursion_depth_text,
                     3, 4, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     0,3);
    gtk_widget_set_usize(GTK_WIDGET(recursion_depth_text),20,20);
    gtk_widget_show (recursion_depth_text);
    gtk_widget_show (hbox);
    gtk_widget_show (table);
   /*----end small entry tables---*/

}
/*------------------------------------------------------------------------
-                              end page_build_1                          -
-------------------------------------------------------------------------*/


/*----------------------------------------------------------------------
-                             Begin page_build_2                       -
-----------------------------------------------------------------------*/
void page_build_2()
{

    /*--------------------
    -     Table 12x3     -
    ---------------------*/
    table = gtk_table_new (13, 3, FALSE);
    gtk_table_set_col_spacing(GTK_TABLE(table),0,12);
    gtk_container_add (GTK_CONTAINER (frame), table);

    /*----------------------------------------------------------------------
    -              -A,  --accept=LIST (text entry)                        -
    -----------------------------------------------------------------------*/
    label = gtk_label_new ("Accept Types:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 0, 1);
    gtk_widget_show (label);

    accept_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), accept_text, 1, 2, 0, 1);
    gtk_widget_show (accept_text);

    /*----------------------------------------------------------------------
    -         -R,  --reject=LIST    (text entry and checkbox)              -
    -----------------------------------------------------------------------*/
    label = gtk_label_new ("Reject Types:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 1, 2);
    gtk_widget_show (label);

    reject_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), reject_text, 1, 2, 1, 2);
    gtk_widget_show (reject_text);

    /*----------------------------------------------------------------------
    -          -D,  --domains=LIST  (text entry and checkbox)              -
    -----------------------------------------------------------------------*/
    label = gtk_label_new ("Accept Domains:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 2, 3);
    gtk_widget_show (label);

    domains_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), domains_text, 1, 2, 2, 3);
    gtk_widget_show (domains_text);

    /*-----------------------------------------------------------------------
    -           --exclude-domains=LIST  (text entry and checkbox)           -
    ------------------------------------------------------------------------*/
    label = gtk_label_new ("Exclude Domains:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 3, 4);
    gtk_widget_show (label);

    exclude_domains_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), exclude_domains_text, 
                               1, 2, 3, 4);
    gtk_widget_show (exclude_domains_text);

    /*-----------------------------------------------------------------------
    -      -I,  --include-directories=LIST  (text entry and checkbox)       -
    ------------------------------------------------------------------------*/
    label = gtk_label_new ("Include Directories:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 4, 5);
    gtk_widget_show (label);

    include_directories_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), include_directories_text, 
                               1, 2, 4, 5);
    gtk_widget_show (include_directories_text);

    /*-----------------------------------------------------------------------
    -      -X,  --exclude-directories=LIST  (text entry and checkbox)       -
    ------------------------------------------------------------------------*/
    label = gtk_label_new ("Exclude Directories:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 5, 6);
    gtk_widget_show (label);

    excluded_directories_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), excluded_directories_text, 
                               1, 2, 5, 6);
    gtk_widget_show (excluded_directories_text);

    /*-----------------------------------------------------------------------
    -    -Q,  --quota=NUMBER           set retrieval quota to NUMBER.       -
    ------------------------------------------------------------------------*/
    label = gtk_label_new ("Quota Num Files:");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 6, 7);
    gtk_widget_show (label);

    quota_text = gtk_entry_new_with_max_length(256);
    gtk_table_attach_defaults (GTK_TABLE(table), quota_text, 1, 2, 6, 7);
    gtk_widget_show (quota_text);

    /*---- same line ----*/
    /*-----------------------------------------------------------------------
    -     -H,  --span-hosts  (Check box -- with xpm and severe warning )    -
    ------------------------------------------------------------------------*/
    span_hosts_check = gtk_check_button_new_with_label("Span Hosts");
    gtk_table_attach(GTK_TABLE(table),
                     span_hosts_check,
                     0, 1, 7, 8,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (span_hosts_check);


    /*-----------------------------------------------------------------------
    -          -L,  --relative                      checkbox                -
    ------------------------------------------------------------------------*/
    relative_check = gtk_check_button_new_with_label ("Relative");
    gtk_table_attach(GTK_TABLE(table),
                     relative_check,
                     1, 2, 7, 8,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (relative_check);
    /*---- end same line ----*/

    /*------------------------------------------------------------------------
    -      Underlined    LABEL -------- ftp options-----                     -
    -------------------------------------------------------------------------*/

    /*-----------------------------------------------------------------------
    -              --follow-ftp                     checkbox                -
    ------------------------------------------------------------------------*/
    label = gtk_label_new ("FTP OPTIONS                ");
    gtk_label_set_pattern (GTK_LABEL (label), "___________");
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_table_attach(GTK_TABLE(table),
                     label,
                     0, 1, 8, 9,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (label);


    follow_ftp_check = gtk_check_button_new_with_label("Follow FTP links     ");
    gtk_table_attach(GTK_TABLE(table),
                     follow_ftp_check,
                     1, 2, 8, 9,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (follow_ftp_check);

    /*---- same line  ----*/
    /*------------------------------------------------------------------------
    -       --retr-symlinks   retrieve FTP symbolic links. (checkbox)        -
    -------------------------------------------------------------------------*/
    ftp_symlinks_check=gtk_check_button_new_with_label("Retrieve FTP symlinks");
    gtk_table_attach(GTK_TABLE(table),
                     ftp_symlinks_check,
                     0, 1, 9, 10,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (ftp_symlinks_check);

    /*------------------------------------------------------------------------
    -   -g,  --glob=on/off     turn file name globbing on or off. (checkbox) -
    -------------------------------------------------------------------------*/
    file_globbing_check=gtk_check_button_new_with_label("Filename Glob       ");
    gtk_table_attach(GTK_TABLE(table),
                     file_globbing_check,
                     1, 2, 9, 10,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (file_globbing_check);
    /*---- end same line ----*/


    /*---- same line  ----*/
    /*------------------------------------------------------------------------
    -     --passive-ftp     use the "passive" transfer mode. (checkbox)      -
    -------------------------------------------------------------------------*/
    passive_ftp_check=gtk_check_button_new_with_label("Passive FTP           ");
    gtk_table_attach(GTK_TABLE(table),
                     passive_ftp_check,
                     0, 1, 10, 11,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show (passive_ftp_check);

    /*------------------------------------------------------------------------
    -     --follow-ftp  follow FTP links from HTML documents. (checkbox)     -
    -------------------------------------------------------------------------*/
    gtk_widget_show (table);
    /*---- end same line ----*/
}
/*------------------------------------------------------------------------
-                              end page_build_2                          -
-------------------------------------------------------------------------*/

/*----------------------------------------------------------------------
-                             Begin page_build_3                       -
-----------------------------------------------------------------------*/
void page_build_3()
{


    vbox = gtk_vbox_new(FALSE,0);
    table = gtk_table_new (2, 3, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_container_add (GTK_CONTAINER (vbox), table);
    gtk_widget_show (vbox);

    /*----Same line----*/
    /*---------------------------------------------------
    -  -i,  --input-file=FILE      read URL-s from file. -
    -----------------------------------------------------*/
    hbox= gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    input_file_text= gtk_entry_new_with_max_length(256);
    gtk_table_attach(GTK_TABLE(table),
                     input_file_text,
                     1, 2, 0, 1,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(input_file_text);
    gtk_widget_show(hbox);

    /*---------------------------------------------------------
    -                     browse button                       -
    ----------------------------------------------------------*/
    button=gtk_button_new_with_label("Browse");
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     0, 1, 0, 1,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);

    /*--------------------------------------------------------
    - -F,  --force-html           treat input file as HTML.  -
    ---------------------------------------------------------*/
    force_html_check=gtk_check_button_new_with_label("Treat
as HTML");
    gtk_table_attach(GTK_TABLE(table),
                     force_html_check,
                     2, 3, 0, 1,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(force_html_check);
    /*----end same line----*/

    /*-----same line-----*/
    /*-------------------------------------------------------
    - Create input file from Clist --- widget of it's own ~ -
    --------------------------------------------------------*/
    button=gtk_button_new_with_label("Create
InFile");
    gtk_table_attach(GTK_TABLE(table),
                     button,
                     0, 1, 1, 2,
                     GTK_SHRINK,GTK_SHRINK,
                     3,3);
    gtk_widget_show(button);

    /*---------------------------------------------
    -  remove entry on successfull retrieval Y/N  -
    ----------------------------------------------*/
    remove_input_file_lines_check=gtk_check_button_new_with_label("Remove
entries");
    gtk_table_attach(GTK_TABLE(table),
                     remove_input_file_lines_check,
                     2, 3, 1, 2,
                     GTK_FILL,GTK_SHRINK,
                     3,3);
    gtk_widget_show(remove_input_file_lines_check);
    gtk_widget_show(table);
    /*-----end same line----*/

    /*--------------------------------------------
    -  Label -------------Parallelize----------- -
    ---------------------------------------------*/

    /*----------------------
    -   Parrallelize Y/N   -
    -----------------------*/
    /*-----------------------
    -    number of WGET's   -
    ------------------------*/

    gtk_widget_show(vbox);

    /*---------------------------------------------------
    - -o,  --output-file=FILE                Text entry -
    ----------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,20);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    label=gtk_label_new("Logging Output File:");
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
    output_file_text=gtk_entry_new_with_max_length(256);
    gtk_container_add (GTK_CONTAINER (hbox),output_file_text);
    gtk_widget_show(hbox);
    gtk_widget_show(output_file_text);
    gtk_widget_show(label);

    /*-------------------------------------------------------
    -  -a,  --append-output=FILE   append messages to FILE. -
    --------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,20);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    label=gtk_label_new("Logging Append File");
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
    append_file_text=gtk_entry_new_with_max_length(256);
    gtk_container_add (GTK_CONTAINER (hbox),append_file_text);
    gtk_widget_show(hbox);
    gtk_widget_show(append_file_text);
    gtk_widget_show(label);

    /*-----------------------------------------
    -  -O   --output-document=FILE text entry -
    ------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,20);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    gtk_widget_show(hbox);
    label=gtk_label_new("Download to File");
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);   
    output_document_text=gtk_entry_new_with_max_length(256);
    gtk_container_add(GTK_CONTAINER(hbox),output_document_text);
    gtk_widget_show(output_document_text);
    gtk_widget_show(label);
  
    /*--------------------------------------------------------
    -  --dot-style=STYLE        set retrieval display style. -
    ---------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,20);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    gtk_widget_show(hbox);
    label=gtk_label_new("Dot Style");
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
    dot_style_text=gtk_entry_new_with_max_length(256);
    gtk_container_add(GTK_CONTAINER(hbox),dot_style_text);
    gtk_widget_show(dot_style_text);
    gtk_widget_show(label);

    /*-----------------------------------------------------------
    - -q,  --quiet                quiet (no output). (checkbox) -
    ------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,20);
    quiet_check=gtk_check_button_new_with_label("Quiet");
    gtk_container_add (GTK_CONTAINER (vbox),hbox);
    gtk_box_pack_start(GTK_BOX(hbox),quiet_check,FALSE,FALSE,0);
    gtk_widget_show(quiet_check);
    gtk_widget_show(hbox);


    /*---------------------------------------
    -    Label ----------debug----------    -
    ----------------------------------------*/
    label=gtk_label_new("Debugging");
    gtk_label_set_pattern(GTK_LABEL(label),"_________");
    gtk_container_add(GTK_CONTAINER(vbox),label);
    gtk_widget_show(label);

    hbox=gtk_hbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    gtk_widget_show(hbox);
    table=gtk_table_new(3,2,TRUE);
    gtk_box_pack_start(GTK_BOX(hbox),table,FALSE,FALSE,0);
    gtk_widget_show(table);

    /*----same line----*/
    /*------------------------------------------------------------
    -  -S,  --server-response  print server response. (checkbox) -
    -------------------------------------------------------------*/
    server_response_check=gtk_check_button_new_with_label("Server Response");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(server_response_check),
                     0,1,0,1,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(server_response_check);
 
    /*---------------------------------------------------------------
    -  --spider                 don't download anything. (checkbox) -
    ----------------------------------------------------------------*/
    spider_check=gtk_check_button_new_with_label("Spider");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(spider_check),
                     1,2,0,1,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(spider_check);
    /*----end same line----*/

    /*----same line----*/
    /*----------------------------------------------------------------
    -   -d,  --debug                print debug output. (checkbox)   -
    -----------------------------------------------------------------*/
    debug_check=gtk_check_button_new_with_label("Debug");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(debug_check),
                     0,1,1,2,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(debug_check);

    /*--------------------------------------------------------------
    -             -s,  --save-headers       (checkbox)             -
    ---------------------------------------------------------------*/
    save_headers_check=gtk_check_button_new_with_label("Save Headers");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(save_headers_check),
                     1,2,1,2,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(save_headers_check);
    /*----end same line----*/

    /*----same line----*/
    /*---------------------------------------------------------------------
    - -v,  --verbose      (exlusive checkboxes) -- not needed exclusivity -
    ----------------------------------------------------------------------*/
    verbose_check=gtk_check_button_new_with_label("Verbose");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(verbose_check),
                     0,1,2,3,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(verbose_check);

    /*-----------------------------------------------------------------
    -                         -nv, --non-verbose                      -
    ------------------------------------------------------------------*/
    non_verbose_check=gtk_check_button_new_with_label("Non Verbose");
    gtk_table_attach(GTK_TABLE(table),GTK_WIDGET(non_verbose_check),
                     1,2,2,3,
                     GTK_FILL,
                     GTK_SHRINK,
                     0,0);
    gtk_widget_show(non_verbose_check);
    /*----end same line----*/
}
/*------------------------------------------------------------------------
-                              end page_build_3                          -
-------------------------------------------------------------------------*/

/*----------------------------------------------------------------------
-                             Begin page_build_4                       -
-----------------------------------------------------------------------*/
void page_build_4()
{
    vbox=gtk_vbox_new(FALSE,0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);

    /*-------------------
    - Label -   Proxy:  -
    --------------------*/
    gtk_widget_show(vbox);

    /*------------------------------------------------------------------------
    -  -Y,  --proxy=on/off   (Proxy on acivates the following  text inputs)  -
    -------------------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    use_proxy_check=gtk_check_button_new_with_label("Use Proxy");
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    label=gtk_label_new("             ");
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (hbox), use_proxy_check);
    gtk_widget_show(use_proxy_check);
    gtk_widget_show(hbox);
    gtk_widget_show(label);

    /*---------------------------------------------------
    - --proxy-user=USER     set USER as proxy username. -
    ----------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("Proxy User:");
    proxy_user_text= gtk_entry_new_with_max_length(256);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER (hbox),proxy_user_text);
    gtk_widget_show(proxy_user_text);
    gtk_widget_show(hbox);

   
    /*---------------------------------------------------
    - --proxy-passwd=PASS   set PASS as proxy password. -
    ----------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("Proxy Password:");
    proxy_passwd_text= gtk_entry_new_with_max_length(256);
    gtk_entry_set_visibility(GTK_ENTRY(proxy_passwd_text),FALSE);
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER (hbox),proxy_passwd_text);
    gtk_widget_show(proxy_passwd_text);
    gtk_widget_show(hbox);

    /*---------------------
    -  Label HTTP logins: -
    ----------------------*/
    label=gtk_label_new("HTTP Logins");
    gtk_label_set_pattern (GTK_LABEL (label), "___________");
    gtk_container_add (GTK_CONTAINER (vbox), label);
    gtk_widget_show(label);

    /*--------------------------------------------
    - --http-user=USER (text entry and checkbox) -
    ---------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("HTTP User:");
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_widget_show(label);
    http_user_text= gtk_entry_new_with_max_length(256);
    gtk_container_add (GTK_CONTAINER (hbox), http_user_text);
    gtk_widget_show(http_user_text);
    gtk_widget_show(hbox);

    /*----------------------------------------------
    - --http-passwd=PASS (text entry and checkbox) -
    -----------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("HTTP Password:");
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_widget_show(label);
    http_password_text= gtk_entry_new_with_max_length(256);
    gtk_entry_set_visibility(GTK_ENTRY(http_password_text),FALSE);
    gtk_container_add (GTK_CONTAINER (hbox), http_password_text);
    gtk_widget_show(http_password_text);
    gtk_widget_show(hbox);

    /*--------------
    -  Label Other -
    ---------------*/
    label=gtk_label_new("Other");
    gtk_label_set_pattern (GTK_LABEL (label), "_____");
    gtk_container_add (GTK_CONTAINER (vbox), label);
    gtk_widget_show(label);
 
    /*----same line----*/
    /*-------------------------------------------------
    -  -nh, --no-host-lookup               (checkbox) -
    --------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    no_host_lookup_check=gtk_check_button_new_with_label("No Host Lookup");
    gtk_box_pack_start(GTK_BOX(hbox),no_host_lookup_check,FALSE,FALSE,0);
    gtk_widget_show(hbox);
    gtk_widget_show(no_host_lookup_check);
    
    /*-----------------------------------------------------------------------
    -  -nr, --dont-remove-listing don't remove `.listing' files. (checkbox) -
    ------------------------------------------------------------------------*/
    dont_remove_listing_check=gtk_check_button_new_with_label("Don't Remove Listing");
    gtk_container_add(GTK_CONTAINER(hbox),dont_remove_listing_check);
    gtk_widget_show(dont_remove_listing_check);
    /*----end same line----*/

    /*-----------------------------------------------------------------------
    -       --delete-after      (for speed test ?? ) (checkbox)             -
    ------------------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    delete_after_check=gtk_check_button_new_with_label("Delete Downloads");
    gtk_box_pack_start(GTK_BOX(hbox),delete_after_check,FALSE,FALSE,0);
    label=gtk_label_new("   ");
    gtk_container_add(GTK_CONTAINER(hbox),label);
    gtk_widget_show(delete_after_check);
    gtk_widget_show(hbox);
    gtk_widget_show(label);
   
    /*--------------------------------------------------------
    - --header=STRING       insert STRING among the headers. -
    ---------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("Header String:");
    gtk_box_pack_start(GTK_BOX(hbox),label, FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    gtk_widget_show(label);
    http_password_text= gtk_entry_new_with_max_length(256);
    gtk_container_add (GTK_CONTAINER (hbox), http_password_text);
    gtk_widget_show(http_password_text);
    gtk_widget_show(hbox);

    /*------------------------------------------------------------------
    - -e,  --execute=COMMAND   execute a `.wgetrc' command. text entry -
    -------------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("Wgetrc Command");
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    wgetrc_command_text=gtk_entry_new_with_max_length(22);
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
    gtk_container_add(GTK_CONTAINER(hbox),wgetrc_command_text);
    gtk_widget_show(wgetrc_command_text);
    gtk_widget_show(hbox);
    gtk_widget_show(label);

    
    /*-----------------------------------------------------------------
    -  --cut-dirs=NUMBER   ignore NUMBER remote dir components.(text) -
    ------------------------------------------------------------------*/
    hbox=gtk_hbox_new(TRUE,0);
    label=gtk_label_new("Cut Number Dirs");
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    wgetrc_command_text=gtk_entry_new_with_max_length(22);
    gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
    gtk_container_add(GTK_CONTAINER(hbox),wgetrc_command_text);
    gtk_widget_show(wgetrc_command_text);
    gtk_widget_show(hbox);
    gtk_widget_show(label);
}
/*------------------------------------------------------------------------
-                              end page_build_4                          -
-------------------------------------------------------------------------*/


/*----------------------------------------------------------------------
-                             Begin page_build_5                       -
-----------------------------------------------------------------------*/
void page_build_5()
{
        label = gtk_label_new ("Settings");
        gtk_container_add (GTK_CONTAINER (frame), label);
        gtk_widget_show (label);
}
/*------------------------------------------------------------------------
-                              end page_build_5                          -
-------------------------------------------------------------------------*/

/*--------------END NOTEBOOK BUILD FUNCTIONS----------------*/

/*-------------------------------------------------------------------
-  select_user_agent creates a clist to select the user agent. This -
-  should read agents from a file                                   -
--------------------------------------------------------------------*/
void select_user_agent()
{
    printf("select_user_agent pulls up a clist to select user agents\n");
}

/*---------------------------------------------------------------------------
-                  fetch - get all args and execute the fetch               -
----------------------------------------------------------------------------*/
int fetch(void)
{
    FILE *fs;

    get_input();
    fs = popen(command_line, "r");
    if(fs != NULL)
    {
        show_file_text(fs,0,0,620,500,"Fetching Files",2,TRUE);
        fclose(fs);
    }
    else
        printf("Could not open pipe in fetch !\n");
    
    return(0);
}


/*-----------------------------------------------------------------------------
-                          add_entry_to_command_line                          -
------------------------------------------------------------------------------*/
void add_entry_to_command_line(GtkWidget *to_add, char *flag)
{
    char *temp = "                                                                                    ";

    temp = gtk_entry_get_text(GTK_ENTRY(to_add));
    if(!EMPTY(temp))
        command_line_place += sprintf(command_line_place," %s%s",flag,temp);

}

/*-----------------------------------------------------------------------------
-                          add_check_to_command_line                          -
------------------------------------------------------------------------------*/
void add_check_to_command_line(GtkWidget *to_add, char *flag)
{
    char *temp = "                                                                                    ";

    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(to_add)))
        command_line_place += sprintf(command_line_place," %s",flag);
}

/*-----------------------------------------------------------------------------
-                                 get_input                                   -
------------------------------------------------------------------------------*/
void get_input(void)
{
    char *temp = "                                                                                    ";
    
    memset(command_line,0,1024);
    command_line_place = command_line;

    temp = gtk_entry_get_text(GTK_ENTRY(url_text));
    command_line_place += sprintf(command_line_place,"wget %s",temp);

    add_entry_to_command_line(download_dir_text, "-P ");
    add_entry_to_command_line(agent_text, "-U ");
    add_entry_to_command_line(wait_text, "-w ");
    add_entry_to_command_line(recursion_depth_text, "-l ");
    add_entry_to_command_line(accept_text, "-A " );
    add_entry_to_command_line(reject_text, "-R " );
    add_entry_to_command_line(domains_text, "-D " );
    add_entry_to_command_line(exclude_domains_text, "--exclude-domains=" );
    add_entry_to_command_line(include_directories_text, "-I " );
    add_entry_to_command_line(excluded_directories_text, "-X " );
    add_entry_to_command_line(input_file_text, "-i " );
    add_entry_to_command_line(quota_text, "-Q " );
    add_entry_to_command_line(timeout_text, "-T " );
    add_entry_to_command_line(tries_text, "-t " );
    add_entry_to_command_line(proxy_user_text, "--proxy-user=" );
    add_entry_to_command_line(output_document_text, "-o " );
    add_entry_to_command_line(wgetrc_command_text, "-e " );
    add_entry_to_command_line(dot_style_text, "--dot-style=" );
    add_entry_to_command_line(proxy_passwd_text, "--proxy-passwd=" );
    add_entry_to_command_line(http_user_text, "--http-user=" );
    add_entry_to_command_line(http_password_text, "--http-passwd=" );
    add_entry_to_command_line(output_file_text, "-o " );
    add_entry_to_command_line(append_file_text, "-a " );


    add_check_to_command_line(recursive_check , "-r");
    add_check_to_command_line(no_parent_check , "-np");
    add_check_to_command_line(no_clobber_check  ,"-nc");
    add_check_to_command_line(continue_check  , "-c");
//    add_check_to_command_line(background_check , "-b");
    add_check_to_command_line(timestamping_check  , "-N");
    add_check_to_command_line(span_hosts_check , "-H");
    add_check_to_command_line(no_host_dirs_check , "-nH");
    add_check_to_command_line(relative_check , "-k");
    add_check_to_command_line(follow_ftp_check , "--follow-ftp");
    add_check_to_command_line(ftp_symlinks_check , "--retr-symlinks");
    add_check_to_command_line(passive_ftp_check , "--passive-ftp");
    add_check_to_command_line(file_globbing_check , "-g");
    add_check_to_command_line(mirroring_check , "-m");
    add_check_to_command_line(no_directories_check , "-nd");
    add_check_to_command_line(force_directories_check , "-x");
    add_check_to_command_line(disallow_cache_check , "-C");
    add_check_to_command_line(force_html_check , "-F");
    add_check_to_command_line(quiet_check  , "-q");
    add_check_to_command_line(server_response_check , "-S");
    add_check_to_command_line(spider_check , "--spider");
    add_check_to_command_line(debug_check , "-d");
    add_check_to_command_line(save_headers_check , "-s");
    add_check_to_command_line(verbose_check , "-v");
    add_check_to_command_line(non_verbose_check , "-nv");
    add_check_to_command_line(no_host_lookup_check , "-nh");
    add_check_to_command_line(dont_remove_listing_check , "-nr");
    add_check_to_command_line(delete_after_check , "--delete-after");
    add_check_to_command_line(use_proxy_check , "-Y");

/*--- seems redundant ---*/
//    add_check_to_command_line(follow_ftp_links_check , "  ");
/*--- mistake ? ---*/
    add_check_to_command_line(convert_to_non_rel_check , "  ");
/*--- For the Future ---*/
    add_check_to_command_line(remove_input_file_lines_check , "  ");

    sprintf(command_line_place," 2>&1 ");
}
